using System;
using System.Collections.Generic;
using System.Linq;

class Article
{
    public int weight;
    public int value;
    public float valuePerWeight;

    public Article(int weight, int value)
    {
        this.weight = weight;
        this.value = value;
        valuePerWeight = (float)value / weight;
    }
}

class Program
{
    static void Main()
    {
        string[] first = Console.ReadLine().Split();
        int n = int.Parse(first[0]);
        int W = int.Parse(first[1]);
        float e = float.Parse(first[2]);

        Article[] articles = new Article[n];
        for (int i = 0; i < n; i++)
        {
            string[] line = Console.ReadLine().Split();
            int w = int.Parse(line[0]);
            int v = int.Parse(line[1]);
            articles[i] = new Article(w, v);
        }

        var sorted = articles
            .Select((a, index) => new { Article = a, Index = index + 1 })
            .OrderByDescending(a => a.Article.valuePerWeight)
            .ToList();

        int currentWeight = 0;
        List<int> chosen = new List<int>();

        foreach (var item in sorted)
        {
            if (currentWeight + item.Article.weight <= W)
            {
                currentWeight += item.Article.weight;
                chosen.Add(item.Index);
            }
        }

        Console.WriteLine(chosen.Count);
        chosen.Sort();
        Console.WriteLine(string.Join(" ", chosen));
    }
}